unit VrcholThread;

interface

uses
  Classes, Defs, SysUtils, Windows;

type
  TVrcholThr = class(TThread)
  private
    Vrchol:PTVrchol;
    PoppedCnt:Integer;    //rika, z kolika vrcholu jsme jiz precetli zpravu

    function PopMsg(from:PTVrchol):TBufElement;
    procedure SendMsg(target:PTVrchol;msg:TBufElement);
    function BuildMsg():TBufElement;
    procedure ReadRouting();
    procedure SendRouting();
    procedure Finished();
  protected
    procedure Execute; override;

  public
    constructor Create(Vrchol:PTVrchol);
    destructor Destroy; override;
  end;


//pokud nenajdu prijemce paketu mezi svymi detmi, poslu to tam, kam jsem posilal routovaci data

implementation

{ Important: Methods and properties of objects in visual components can only be
  used in a method called using Synchronize, for example,

      Synchronize(UpdateCaption);

  and UpdateCaption could look like,

    procedure TVrchol.UpdateCaption;
    begin
      Form1.Caption := 'Updated in a thread';
    end; }

{ TVrchol }

procedure TVrcholThr.Execute;
begin
 try
  while (not Self.Terminated) do
   begin
    Self.ReadRouting();

    //pokud jsme prijmuli zpravy ze vsech vrholu, skoncime
    if (Self.PoppedCnt = Self.Vrchol^.RoutingChilds.Count) then
     begin
      Self.Finished();
      Exit;
     end;

    //pokud jsme dostali zpravy ze vsech vrcholu krome jednoho, tam posleme routovaci tabulky
    if (Self.PoppedCnt = Self.Vrchol^.RoutingChilds.Count-1) then
      Self.SendRouting();
   end;//while
 except

 end;//try, except
end;

constructor TVrcholThr.Create(Vrchol:PTVrchol);
begin
 // Create suspended:
 inherited Create(True);

 Self.Vrchol      := Vrchol;
 Self.PoppedCnt   := 0;
 Vrchol^.RoutingChilds.Count := Vrchol^.Childs.Count;   //tohleto jedine zadani povoluje: vime, kolik je deti

 // Start the thread:
// Self.Resume;
end;//ctor

destructor TVrcholThr.Destroy;
begin
 inherited Destroy;
end;//dtor

//precte zpravu ze zadaneho vrcholu a vymaze ji
function TVrcholThr.PopMsg(from:PTVrchol):TBufElement;
var i,j:Integer;
begin
 Result.msg.Count := 0;

 //precist zpravu
 for i := 0 to Self.Vrchol^.InputBuffer.Count-1 do
  begin
   if (Self.Vrchol^.InputBuffer.Data[i].from = from) then
    begin
     Result := Self.Vrchol^.InputBuffer.Data[i];
     Break;
    end;
  end;//for i

 if (Result.msg.Count = 0) then Exit;

 //smazat zpravu
 for j := i to Self.Vrchol^.InputBuffer.Count-2 do Self.Vrchol^.InputBuffer.Data[i] := Self.Vrchol^.InputBuffer.Data[i+1];
 Self.Vrchol^.InputBuffer.Count := Self.Vrchol^.InputBuffer.Count - 1;
end;//function

procedure TVrcholThr.ReadRouting();
var i:Integer;
    received:TBufElement;
begin
 //format zpravy: /vrcholy ulozene v poli rikajici, ktere vrcholy se nachazeji za odesilatelem
 for i := 0 to Self.Vrchol^.Childs.Count-1 do
  begin
   received := Self.PopMsg(Self.Vrchol^.Childs.Data[i]);
   if (received.msg.Count = 0) then continue;

   //pokud nam prisla zprava, tak si ji ulozime
   Self.Vrchol^.RoutingChilds.Data[i].NextChilds := received.msg;
   Self.PoppedCnt := Self.PoppedCnt + 1;
  end;//for i
end;//procedure

procedure TVrcholThr.SendRouting();
var i:Integer;
begin
 //alespon 1 neprijaty musi exsitovat, to je osetreno uz vys
 for i := 0 to Self.Vrchol^.Childs.Count-1 do
  begin
   if (Self.Vrchol^.RoutingChilds.Data[i].NextChilds.Count <> 0) then continue;

   Self.SendMsg(Self.Vrchol^.Childs.Data[i],Self.BuildMsg());
   Self.Vrchol^.SentRT := Self.Vrchol^.Childs.Data[i];
   Self.Finished();
   Exit;
  end;
end;//procedure

procedure TVrcholThr.SendMsg(target:PTVrchol;msg:TBufElement);
begin
 target^.InputBuffer.Data[target^.InputBuffer.Count] := msg;
 target^.InputBuffer.Count := target^.InputBuffer.Count + 1;
end;//procedure

//sestavit zpravu na odeslani cilovym vrcholum
function TVrcholThr.BuildMsg():TBufElement;
var i,j:Integer;
begin
 Result.from := Self.Vrchol;
 Result.msg.Count := 1;
 Result.msg.Data[0] := Self.Vrchol;

 for i := 0 to Self.Vrchol^.RoutingChilds.Count-1 do
  begin
   for j := 0 to Self.Vrchol^.RoutingChilds.Data[i].NextChilds.Count-1 do
    begin
     Result.msg.Data[Result.msg.Count] := Self.Vrchol^.RoutingChilds.Data[i].NextChilds.Data[j];
     Result.msg.Count := Result.msg.Count + 1;
    end;//for j
  end;//for i
end;//function

procedure TVrcholThr.Finished;
begin
 Self.Suspend;
end;//procedure

end.//thread
